/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#if !MX_OS_WINNT
#include <unistd.h>
#endif
#include "test_common.h"

#if MX_OS_WINNT
#define putenv _putenv
#endif

void
usage()
{
  fprintf(stderr, "Usage: mx_vect_test [args]\n");
  fprintf(stderr, "-s - disable multiple segments on the sender's\n");
  fprintf(stderr, "-r - disable multiple segments on the receiver's\n");
  fprintf(stderr, "-S - disable self communication testing\n");
  fprintf(stderr, "-H - disable shared communication testing\n");
  fprintf(stderr, "-G - disable generic communication testing\n");
}


void fill_segments(mx_segment_t segs[], int count)
{
  int i,j,k=0;
  for(i=0; i<count; i++)
    for(j=0; j<segs[i].segment_length; j++, k++)
      ((char*)segs[i].segment_ptr)[j] = 'a' + (k%26);
}

int check_segments(mx_segment_t segs[], int count, int length)
{
  int i,j,k=0;
  for(i=0; i<count; i++)
    for(j=0; j<segs[i].segment_length && k<length; j++, k++)
      if (((char*)segs[i].segment_ptr)[j] != 'a' + (k%26))
{
printf("diff at %d %d %d\n", i, j, k);
	return -1;
}
  return 0;
}

int simple(mx_endpoint_t ep, mx_endpoint_addr_t addr, int svect, int rvect)
{
  mx_return_t ret;
  mx_segment_t ssegs[5], rsegs[3];
  mx_request_t sreq, rreq;
  mx_status_t status;
  uint32_t result;
  int i;

  if (rvect) {
    rsegs[0].segment_ptr = NULL;
    rsegs[0].segment_length = 0;
    rsegs[1].segment_ptr = calloc(96000, 1);
    rsegs[1].segment_length = 96000;
    rsegs[2].segment_ptr = calloc(1022, 1);
    rsegs[2].segment_length = 1022;
    ret = mx_irecv(ep, rsegs, 3, 0, 0, NULL, &rreq);
    insist(ret == MX_SUCCESS);
  } else {
    rsegs[0].segment_ptr = malloc(97022);
    rsegs[0].segment_length = 97022;
    ret = mx_irecv(ep, rsegs, 1, 0, 0, NULL, &rreq);
    insist(ret == MX_SUCCESS);
  }
  /* total is 97022 */

  if (svect) {
    ssegs[0].segment_ptr = malloc(123);
    ssegs[0].segment_length = 123;
    ssegs[1].segment_ptr = malloc(80567);
    ssegs[1].segment_length = 80567;
    ssegs[2].segment_ptr = NULL;
    ssegs[2].segment_length = 0;
    ssegs[3].segment_ptr = malloc(345);
    ssegs[3].segment_length = 345;
    ssegs[4].segment_ptr = malloc(14987);
    ssegs[4].segment_length = 14987;
    fill_segments(ssegs, 5);
    ret = mx_issend(ep, ssegs, 5, addr, 0, NULL, &sreq);
    insist(ret == MX_SUCCESS);
  } else {
    ssegs[0].segment_ptr = malloc(96022);
    ssegs[0].segment_length = 96022;
    fill_segments(ssegs, 1);
    ret = mx_issend(ep, ssegs, 1, addr, 0, NULL, &sreq);
    insist(ret == MX_SUCCESS);
  }
  /* total is 96022 */

  ret = mx_wait(ep, &rreq, MX_INFINITE, &status, &result);
  insist(ret == MX_SUCCESS);
  insist(result);
  insist(status.code == MX_STATUS_SUCCESS);
  insist(status.xfer_length == 96022);
  ret = mx_test(ep, &sreq, &status, &result);
  insist(ret == MX_SUCCESS);
  insist(result);
  insist(status.code == MX_STATUS_SUCCESS);
  insist(status.xfer_length == 96022);
  
  insist(check_segments(rsegs, 3, 96022) == 0);
  printf("[PASSED]\n");

  for(i=0; i < (svect ? 5 : 1) ; i++)
    free(ssegs[i].segment_ptr);
  for(i=0; i < (rvect ? 3 : 1) ; i++)
    free(rsegs[i].segment_ptr);  
  return 0;
}

int test(int svect, int rvect)
{
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  mx_return_t ret;

  ret = mx_init();
  insist(ret == MX_SUCCESS);

  ret = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(ret == MX_SUCCESS);

  ret = mx_get_endpoint_addr(ep, &addr);
  insist(ret == MX_SUCCESS);

  simple(ep, addr, svect, rvect);

  ret = mx_close_endpoint(ep);
  insist(ret == MX_SUCCESS);

  ret = mx_finalize();
  insist(ret == MX_SUCCESS);

  return 0;
}
  
int
main(int argc, char * argv[])
{
  int svect = 1;
  int rvect = 1;
  int self = 1;
  int shmem = 1;
  int generic = 1;
  int c;

  while ((c = getopt(argc, argv, "hsrSHG")) != EOF) switch(c) {
  case 's':
    svect = 0;
    break;
  case 'r':
    rvect = 0;
    break;
  case 'S':
    self = 0;
    break;
  case 'H':
    shmem = 0;
    break;
  case 'G':
    generic = 0;
    break;
  case 'h':
  default:
    usage();
    exit(1);
  }

  if (self) {
    printf("Testing self communications...\n");
    test(svect, rvect);
  }
  putenv("MX_DISABLE_SELF=1");

  if (shmem) {
    printf("Testing shared communications...\n");
    test(svect, rvect);
  }
  putenv("MX_DISABLE_SHMEM=1");

  if (generic) {
    printf("Testing generic communications...\n");
    test(svect, rvect);
  }

  return 0;
}
